<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

$rc_no = '';
$result_data = [];
$error_msg = '';
$success_msg = '';

// Service Name
$service_name = 'rc-mobile';

// Fetch service price from database
$priceRow = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='$service_name'"));

if ($priceRow) {
    $fee = (float)$priceRow['price'];
} else {
    // If not set, default to 0 and insert
    $fee = 0;
    mysqli_query($ahk_conn, "INSERT INTO pricing (service_name, price) VALUES ('$service_name', '0')");
}

if (isset($_POST['search'])) {
    $rc_no = strtoupper(trim(mysqli_real_escape_string($ahk_conn, $_POST['rc_no'])));
    $username = $udata['phone'];
    $wallet_amount = (float)$udata['balance'];
    
    // Basic Validation
    if (empty($rc_no)) {
        echo "<script>Swal.fire('Invalid Input', 'Please enter Vehicle Number (RC No)', 'warning');</script>";
    } elseif ($wallet_amount < $fee) {
        echo "<script>Swal.fire('Insufficient Balance', 'You need ₹$fee to use this service.', 'error');</script>";
    } else {
        
        // Use centralized configuration
        if (empty($new_api_key) || empty($new_api_url)) {
             $error_msg = "System Error: New API Configuration Missing. Please check settings.";
        } else {
            // Build URL
            $base = rtrim($new_api_url, '/');
            if (strpos($base, 'index.php') !== false) {
                $url = $base;
            } else {
                $url = $base . '/index.php';
            }
            
            // Prepare Data
            $params = [
                'api_key' => $new_api_key,
                'service' => $service_name,
                'rc_no'   => $rc_no
            ];
            
            // Initialize CURL
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($params),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_TIMEOUT => 60
            ]);

            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                $error_msg = "API Connection Error: " . $curl_error;
            } else {
                $api = json_decode($response, true);
                
                // Parse Response
                // Format: {"status":"success", ..., "data": { "status":"success", "data": { "rc_no":"...", "mobile_no":"..." } } }
                
                $is_success = false;
                
                if (isset($api['status']) && $api['status'] === 'success') {
                    if (isset($api['data']['data']['mobile_no'])) {
                        $is_success = true;
                        $result_data = $api['data']['data'];
                    } elseif (isset($api['data']['mobile_no'])) {
                        $is_success = true;
                        $result_data = $api['data'];
                    }
                }
                
                if ($is_success) {
                    $success_msg = "Details fetched successfully for RC: " . htmlspecialchars($rc_no);
                    
                    // Deduct Balance (if not handled by API automatically, but usually API handles it if it's internal)
                    // The API response shows "balance_deducted": 0. 
                    // If the API is internal (run.rtyu.tech), it might handle deduction. 
                    // However, in pan-adhaar-status.php we did manual deduction.
                    // Let's check if 'balance_deducted' > 0 in response.
                    
                    if (isset($api['balance_deducted']) && $api['balance_deducted'] > 0) {
                        // Already deducted by API
                        // Refresh user balance in session/DB if needed
                    } else {
                        // Manual deduction if API didn't deduct (and if we are charging)
                        if ($fee > 0) {
                             mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $fee WHERE phone = '$username'");
                             mysqli_query($ahk_conn, "INSERT INTO wallet_history (user_id, amount, type, description, date) VALUES ('{$udata['id']}', '$fee', 'debit', 'RC Mobile Search: $rc_no', NOW())");
                        }
                    }
                    
                } else {
                    $error_msg = $api['message'] ?? ($api['data']['message'] ?? 'Data not found or API failed.');
                }
            }
        }
    }
}
?>

<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Admin Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">RC Mobile Details</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="container-fluid pt-4 px-4">
            <div class="row">
                <!-- Search Form -->
                <div class="col-lg-12 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title mb-4 d-flex justify-content-between align-items-center">
    Search RC Mobile Details
    <span class="badge bg-danger">Fee: ₹<?= number_format($fee, 2) ?></span>
</h5>
                            <form method="POST" class="row g-3">
                                <div class="col-md-8">
                                    <input type="text" name="rc_no" class="form-control" placeholder="Enter Vehicle Number (e.g. DL9CU1543)" 
                                           value="<?= isset($_POST['rc_no']) ? htmlspecialchars($_POST['rc_no']) : '' ?>" 
                                           required>
                                </div>
                                <div class="col-md-4">
                                    <button type="submit" name="search" class="btn btn-primary w-100">Search</button>
                                </div>
                            </form>
                            
                            <?php if($error_msg): ?>
                                <div class="alert alert-danger mt-3" role="alert">
                                    <?= htmlspecialchars($error_msg) ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($success_msg): ?>
                                <div class="alert alert-success mt-3" role="alert">
                                    <?= htmlspecialchars($success_msg) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Results Display -->
                <?php if($result_data): ?>
                <div class="col-lg-12">
                    <div class="card border-top border-0 border-4 border-primary">
                        <div class="card-body p-5">
                            <div class="card-title d-flex align-items-center">
                                <div><i class="bx bxs-car me-1 font-22 text-primary"></i></div>
                                <h5 class="mb-0 text-primary">RC Details</h5>
                            </div>
                            <hr>
                            
                            <div class="row g-3">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-secondary">Vehicle Number (RC)</label>
                                    <div class="h5"><?= htmlspecialchars($result_data['rc_no'] ?? '-') ?></div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-secondary">Mobile Number</label>
                                    <div class="h5 text-success"><?= htmlspecialchars($result_data['mobile_no'] ?? '-') ?></div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-secondary">Status</label>
                                    <div class="h6"><?= htmlspecialchars($result_data['Status'] ?? '-') ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
